-- This file is part of Practical Distributed Processing
-- Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige

with Ada.Command_Line;
with Ada.Text_IO;      use Ada.Text_IO;

procedure Tasks is

   task type Square is
      entry Start      (I : in     Integer);
      entry Get_Result (R :    out Integer);
   end Square;

   task body Square is
      J : Integer;
      V : Integer;
   begin
      Put_Line("A Square task is starting...");
      accept Start (I : in Integer) do
         J := I;
         Put_Line("A Square task has been given J =" & Integer'Image(J));
      end Start;
      V := J * J;
      Put_Line("A Square task has calculated V =" & Integer'Image(V));
      accept Get_Result (R : out Integer) do
         R := V;
      end Get_Result;
      Put_Line("A Square task is ending.");
   end Square;

   P : Positive;
   T : Natural  := 0;
begin
   Put_Line("Tasks example starting...");
   -- We hope that the first argument is a positive number.
   -- No error checking here.
   P := Positive'Value(Ada.Command_Line.Argument(1));
   declare
      -- This starts P tasks.
      S : array (1..P) of Square;
      R : Integer;
   begin
      for I in S'Range loop
         S(I).Start(I);
      end loop;
      -- Then add up the numbers.
      for I in S'Range loop
         S(I).Get_Result(R);
         T := T + R;
      end loop;
   end;
   Put_Line("Tasks example ending, sum of squares 1 to"
            & Integer'Image(P)
            & " is"
            & Integer'Image(T)
            & ".");
end Tasks;

