-- This file is part of Practical Distributed Processing
-- Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige

with Collections;         use Collections, Collections.CXA;
with Events;              use Events;
with Events.Ops;          use Events.Ops, Events.Ops.EXA;
with Factory;             use Factory;
with Processes;           use Processes, Processes.FPA, Processes.PXA;

procedure Deadlock is
   AlphaP, AlphaQ, AlphaA, AlphaB : Collection;
   AlphaPQ, AlphaAB : Collection;
begin
   Decl("P",
        Prefix("lock_AP",
               Prefix("lock_BP",
                      Prefix("P_does_stuff",
                             Prefix("unlock_BP",
                                    Prefix("unlock_AP",
                                           Call("P")))))));
   Decl("Q",
        Prefix("lock_BQ",
               Prefix("lock_AQ",
                      Prefix("Q_does_stuff",
                             Prefix("unlock_AQ",
                                    Prefix("unlock_BQ",
                                           Call("Q")))))));
   Decl("A",
        ExtChoice(+Prefix("lock_AP",
                          Prefix("unlock_AP",
                                 Call("A")))
                  +Prefix("lock_AQ",
                          Prefix("unlock_AQ",
                                 Call("A")))));
   Decl("B",
        ExtChoice(+Prefix("lock_BP",
                          Prefix("unlock_BP",
                                 Call("B")))
                  +Prefix("lock_BQ",
                          Prefix("unlock_BQ",
                                 Call("B")))));
   AlphaP := New_Collection(A => +"P_does_stuff"
                            +"lock_AP"
                            +"lock_BP"
                            +"unlock_AP"
                            +"unlock_BP");
   AlphaQ := New_Collection(A => +"Q_does_stuff"
                            +"lock_AQ"
                            +"lock_BQ"
                            +"unlock_AQ"
                            +"unlock_BQ");
   AlphaA := New_Collection(A => +"lock_AP"
                            +"lock_AQ"
                            +"unlock_AP"
                            +"unlock_AQ");
   AlphaB := New_Collection(A => +"lock_BP"
                            +"lock_BQ"
                            +"unlock_BP"
                            +"unlock_BQ");
   AlphaPQ := Merge_Collections(+AlphaP +AlphaQ);
   AlphaAB := Merge_Collections(+AlphaA +AlphaB);
   Decl("EXAMPLE",
        AParallel(+Interleave(+Call("P") +Call("Q"))
                  +Interleave(+Call("A") +Call("B")),
                  +AlphaPQ
                  +AlphaAB));

   Decl("FIXED_Q",
        Prefix("lock_AQ",
               Prefix("lock_BQ",
                      Prefix("Q_does_stuff",
                             Prefix("unlock_BQ",
                                    Prefix("unlock_AQ",
                                           Call("FIXED_Q")))))));
   Decl("FIXED_EXAMPLE",
        AParallel(+Interleave(+Call("P") +Call("FIXED_Q"))
                  +Interleave(+Call("A") +Call("B")),
                  +AlphaPQ
                  +AlphaAB));

   Explore("EXAMPLE");
end Deadlock;
