/* 
   This file is part of Practical Distributed Processing
   Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

int main()
{
  int pid;
  
  printf("Original process: PID=%d  PPID=%d\n", 
	 getpid(), getppid());
  
  pid = fork();
  
  if (pid != 0)
    {
      /* This is executed when we're the parent. */
      printf ("Parent: PID=%d  PPID=%d\n", 
	      getpid(), getppid());
      printf ("Parent: Child PID=%d\n", pid);
      sleep (5);   /* I'm going to sleep for 5 seconds */
    }
  else /* pid is zero, so I must be the child */
    {
      printf ("Child: PID=%d  PPID=%d - about to sleep\n", 
	      getpid(), getppid());
      printf ("Child: PID=%d  PPID=%d\n", 
	      getpid(), getppid());
    }
  
  printf ("Process with PID %d terminates.\n", getpid());

  exit(EXIT_SUCCESS);

}



