/* 
   This file is part of Practical Distributed Processing
   Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige
*/

#ifndef _NETSTR_HDR
#define _NETSTR_HDR

#include <sys/socket.h>
#include <sys/types.h>

/* Receive data from the network.  These functions wrap up the issues
   of null-terminated strings.  buf must already be allocated to be
   (at least) len (i.e., 0,1,...,len-2,len-1).  The return value from
   the underlying recv/recvfrom is returned;
   errors/closing/etc. should be handled by the caller. */
int NSrecv(int s, char *buf, int len, int flags);

int NSrecvfrom(int s, char *buf, int len, int flags, 
	       struct sockaddr *from, socklen_t *fromlen);

#endif
