/* 
   This file is part of Practical Distributed Processing
   Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige
*/

#ifndef _NGCOMMON2_HDR
#define _NGCOMMON2_HDR

#include <pthread.h>

/* How often should we update moving items?  (in nanoseconds, so
   1000000000 is one second) */
#define MOVEPERIOD 400000000

/* How often should we send a refresh message? */
#define REFRESHPERIOD 1900000000

/* Spawn delay - how long does a player have to wait?  (microseconds) */
#define SPAWNDELAY 2500000

/* How fast do players move per second? */
#define PLAYERSPEED 20.0

/* How fast do shots move per second? */
#define SHOTSPEED 90.0

/* Proximity distance (radius) that causes a shot to explode. */
#define PROXIMITY 3.0

/* Distance at which players die from an exploding shot. */
#define BLAST 5.0

/* What difference in floats is viewed as no difference? */
#define EPSILON 0.0001

/* We have a linked list of map servers. */
typedef struct map_server_node {
  struct sockaddr_in      udp;
  struct sockaddr_in      tcp;
  struct map_server_node *next;
} msnode;

/* Create a hash of secret_keyword with a string and a nonce integer.
   This should be freed after use. */
char *make_token(char *s, int n);

#endif
