-- This file is part of Practical Distributed Processing
-- Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige

with Ada.Command_Line;
with Ada.Numerics.Float_Random;
with Ada.Text_IO;               use Ada.Text_IO;

procedure PC_EX is

   G : Ada.Numerics.Float_Random.Generator;

   Production_Time  : constant Float := 5.0;
   Consumption_Time : constant Float := 8.0;
   N_Producers      : constant Positive := 3;

   task type Producer;

   task Consumer is
      entry Push_Data (F : in Float);
   end Consumer;

   task body Producer is
   begin
      loop
         delay Duration(Ada.Numerics.Float_Random.Random(G)
                        * Production_Time);
         Put_Line("create_data");
         Consumer.Push_Data(Ada.Numerics.Float_Random.Random(G));
      end loop;
   end Producer;

   task body Consumer is
   begin
      loop
         accept Push_Data (F : in Float) do
            Put_Line("push_data." & Float'Image(F));
         end Push_Data;
         delay Duration(Ada.Numerics.Float_Random.Random(G)
                        * Consumption_Time);
         Put_Line("use_data");
      end loop;
   end;

   Producers : array (1..N_Producers) of Producer;

begin
   null;
end PC_EX;

