-- This file is part of Practical Distributed Processing
-- Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige

separate(Philo)
task body Philosopher is
   My_Name               : Integer;
   Left_Fork, Right_Fork : Fork_Access;
   Left_C, Right_C       : Character;
begin
   accept Name (I : in Integer) do
      My_Name := I;
   end Name;
   accept Set_Forks (Left, Right : in Fork_Access) do
      Left_Fork := Left;
      Right_Fork := Right;
   end Set_Forks;
   Left_Fork.Get_Name(Left_C);
   Right_Fork.Get_Name(Right_C);
   Put_Line("Philosopher" & Integer'Image(My_Name)
            & " will use left fork " & Left_C
            & " and right fork " & Right_C & ".");
   Put_Line("Philosopher" & Integer'Image(My_Name) & " thinking...");
   loop
      delay Duration(Ada.Numerics.Float_Random.Random(G)
                     * Max_Thinking_Time);
      Put_Line("Philosopher" & Integer'Image(My_Name) & " hungry...");
      -- This philosopher picks up the left, then the right fork.
      Left_Fork.Pick_Up;
      Put_Line("Philosopher" & Integer'Image(My_Name)
               & " picked up left fork " & Left_C & "...");
      delay Duration(Ada.Numerics.Float_Random.Random(G)
                     * Fork_Gap_Time);
      Right_Fork.Pick_Up;
      Put_Line("Philosopher" & Integer'Image(My_Name)
               & " picked up right fork " & Right_C & " and is eating...");
      delay Duration(Ada.Numerics.Float_Random.Random(G)
                     * Max_Eating_Time);
      Put_Line("Philosopher" & Integer'Image(My_Name) & " finished eating...");
      -- This philosopher puts down the left, then the right fork.
      Left_Fork.Put_Down;
      Put_Line("Philosopher" & Integer'Image(My_Name)
               & " put down left fork " & Left_C & "...");
      delay Duration(Ada.Numerics.Float_Random.Random(G)
                     * Fork_Gap_Time);
      Right_Fork.Put_Down;
      Put_Line("Philosopher" & Integer'Image(My_Name)
               & " put down right fork " & Right_C & " and is thinking...");
   end loop;
end Philosopher;

