-- This file is part of Practical Distributed Processing
-- Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige

with Ada.Command_Line;
with Ada.Numerics.Float_Random;
with Ada.Text_IO;               use Ada.Text_IO;

procedure Philo is

   G : Ada.Numerics.Float_Random.Generator;

   Max_Thinking_Time : constant Float := 10.0;
   Fork_Gap_Time     : constant Float := 3.0;
   Max_Eating_Time   : constant Float := 15.0;

   protected type Fork is
      entry Pick_Up;
      entry Put_Down;
      procedure Set_Name (C : in Character);
      procedure Get_Name (C : out Character);
   private
      My_Name   : Character := '?';
      Available : Boolean := True;
   end Fork;

   type Fork_Access is access all Fork;
   type Fork_Array is array (Positive range <>) of aliased Fork;
   type Fork_Array_Access is access Fork_Array;

   task type Philosopher is
      entry Name (I : in Integer);
      entry Set_Forks (Left, Right : in Fork_Access);
   end Philosopher;

   type Philosopher_Array is array (Positive range <>) of Philosopher;
   type Philosopher_Array_Access is access Philosopher_Array;

   task body Philosopher is separate;
   protected body Fork is separate;

   N : Positive; -- The number of philosophers (and forks).
begin
   Put_Line("Philosophers example starting...");
   -- We hope that the first argument is a positive number.
   -- No error checking here.
   N := Positive'Value(Ada.Command_Line.Argument(1));
   declare
      P : Philosopher_Array_Access;
      F : Fork_Array_Access;
   begin
      -- Create arrays of the correct size.
      P := new Philosopher_Array(1..N);
      F := new Fork_Array(1..N);
      -- `Name' the forks.
      for I in F.all'Range loop
         F(I).Set_Name(Character'Val(64+I));
      end loop;
      -- Start the philosophers.
      for I in P.all'Range loop
         P(I).Name(I);
         declare
            L, R : Fork_Access;
         begin
            if I = 1 then
               L := F(N)'Access;
            else
               L := F(I-1)'Access;
            end if;
            R := F(I)'Access;
            P(I).Set_Forks(L, R);
         end;
      end loop;
   end;
end Philo;

