/* 
   This file is part of Practical Distributed Processing
   Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige
*/

#include "ngcommon.h"
#include "ngcommon2.h"
#include <arpa/inet.h>
#include <netinet/in.h>
#include <openssl/sha.h>
#include <pthread.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>

char *make_token(char *s, int n) {
  char *x  = malloc(BUFFER_SIZE);
  char *md = malloc(SHA_DIGEST_LENGTH);
  char *t  = malloc((2*SHA_DIGEST_LENGTH)+1); /* +1 for trailing newline. */
  int i;
  snprintf(x, BUFFER_SIZE, "%s %s %d",
	   secret_keyword,
	   s,
	   n);
  SHA1(x, strlen(x), md);
  for (i=0; i<SHA_DIGEST_LENGTH; i++) {
    t[2*i] = md[i] & 0x0f;
    t[(2*i)+1] = (md[i] & 0xf0) >> 4;
  }
  for (i=0; i<SHA_DIGEST_LENGTH*2; i++) {
    if (t[i] < 10) {
      t[i] = t[i] + 48;
    } else {
      t[i] = t[i] + 55;
    }
  }
  t[(2*SHA_DIGEST_LENGTH)] = '\0';
  free(x);
  free(md);
  return t;
}

